import os
import datetime

basedir = os.path.abspath(os.path.dirname(__file__))

LINE_CHANNEL_ACCESS_TOKEN = os.getenv('LINE_CHANNEL_ACCESS_TOKEN')
LINE_CHANNEL_SECRET = os.getenv('LINE_CHANNEL_SECRET')
LINE_CHANNEL_ID = os.getenv('LINE_CHANNEL_ID')
LINE_USER_ID = os.getenv('LINE_USER_ID')

# def create_sqlite_uri(db_name):
#     return "sqlite:///" + os.path.join(basedir, db_name)


def create_mariadb_uri(db_name, username, password, host, port=3306):
    return f"mysql+mysqldb://{username}:{password}@{host}:{port}/{db_name}?charset=utf8mb4"

# class DevelopmentConfig(BaseConfig):
#     DEBUG = False
#     SQLALCHEMY_TRACK_MODIFICATIONS = False
#     SQLALCHEMY_DATABASE_URI = 'postgresql://postgres_n:postgres_p@db:5432/db_name'


class BaseConfig:
    DEBUG = True
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    SECRET_KEY = os.urandom(24)
    # LINE
    LINE_CHANNEL_ACCESS_TOKEN = LINE_CHANNEL_ACCESS_TOKEN
    LINE_CHANNEL_SECRET = LINE_CHANNEL_SECRET
    LINE_CHANNEL_ID = LINE_CHANNEL_ID
    LINE_USER_ID = LINE_USER_ID
    # WTF_CSRF_ENABLED = False


class DevelopmentConfig(BaseConfig):
    DEBUG = False
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    SQLALCHEMY_DATABASE_URI = create_mariadb_uri(
        'test', 'root', 'SDJKHN123', 'mariadb')
    # Redis配置
    REDIS_HOST = 'redis'
    REDIS_PORT = 6379
    REDIS_DB = 0

# class TestingConfig(BaseConfig):
#     TESTING = True
#     SQLALCHEMY_TRACK_MODIFICATIONS = False
#     SQLALCHEMY_DATABASE_URI = create_sqlite_uri("test.db")
#     WTF_CSRF_ENABLED = False


config = {
    'development': DevelopmentConfig,
    'default': DevelopmentConfig,
    'base': BaseConfig
}
